//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID5f3743bf_be79_4491_8617_1cd4a2383f3a
{
    public class Class_Color_Surge : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            iTime = 1,
            CenterX = 2,
            CenterY = 3,
            koefX = 4,
            koefY = 5,
            koefZ = 6,
            k1_phase = 7,
            k1_amp = 8,
            k1_cent = 9,
            backColorR = 10,
            backColorG = 11,
            backColorB = 12,
            backColorA = 13,
            Angle = 14
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var koefX = inputs[(int)InputId.koefX].Eval(context).Value;
            var koefY = inputs[(int)InputId.koefY].Eval(context).Value;
            var koefZ = inputs[(int)InputId.koefZ].Eval(context).Value;
            var koef = new Vector3(koefX, koefY, koefZ);
            var k1_phase = inputs[(int)InputId.k1_phase].Eval(context).Value;
            var k1_amp = inputs[(int)InputId.k1_amp].Eval(context).Value;
            var k1_cent = inputs[(int)InputId.k1_cent].Eval(context).Value;
            var backColorR = inputs[(int)InputId.backColorR].Eval(context).Value;
            var backColorG = inputs[(int)InputId.backColorG].Eval(context).Value;
            var backColorB = inputs[(int)InputId.backColorB].Eval(context).Value;
            var backColorA = inputs[(int)InputId.backColorA].Eval(context).Value;
            var backColor = new Color4(backColorR, backColorG, backColorB, backColorA);
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("koef").AsVector().Set(new Vector3(koefX, koefY, koefZ));
                    _effect.GetVariableByName("k1_phase").AsScalar().Set(k1_phase);
                    _effect.GetVariableByName("k1_amp").AsScalar().Set(k1_amp);
                    _effect.GetVariableByName("k1_cent").AsScalar().Set(k1_cent);
                    _effect.GetVariableByName("backColor").AsVector().Set(new Vector4(backColorR, backColorG, backColorB, backColorA));
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

